//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module CDIALOG.H
//
//-----------------------------------------------------------------------------------

#ifndef _CDIALOG_H_
#define _CDIALOG_H_
										   
/////////////////////////////////////////////////////////////////////
// Includes
//
/////////////////////////////////////////////////////////////////////
#include "Common.h"
#include "DataSource.h"
#include "List.h"

/////////////////////////////////////////////////////////////////////
// Forwards
//
/////////////////////////////////////////////////////////////////////
class CEnum;
class CRowset;
class CMainWindow;
class CMDIChild;
class CListBox;
class COptionsDlg;


/////////////////////////////////////////////////////////////////////
// Functions
//
/////////////////////////////////////////////////////////////////////
void*  SetThis(HWND hWnd, LONG lParam);
void*  GetThis(HWND hWnd);
	

/////////////////////////////////////////////////////////////////
// Defines 
//
/////////////////////////////////////////////////////////////////
#define MAX_LISTVIEWROWS		12
#define MAX_RESTRICTIONS		12				//Maximum Restrictions
#define MAX_RECENTCONFIGS		10
#define MAX_RECENTFILES			10

enum CONNECT_OPTIONS
{
	CONNECT_INITIALIZE		= 0x00000001,
	CONNECT_SETPROPERTIES	= 0x00000002,
	CONNECT_CREATESESSION	= 0x00000004,
	CONNECT_CREATECOMMAND	= 0x00000008,
	CONNECT_USESERVICECOMP	= 0x00000010,
};

enum ROWSET_OPTIONS
{
	ROWSET_BINDBOOKMARK		= 0x00000001,
	ROWSET_AUTOQI			= 0x00000002,
	ROWSET_SETDEFAULTPROPS	= 0x00000004,
	ROWSET_GETALLROWS		= 0x00000008,
	ROWSET_GETNOROWS		= 0x00000010,
	
	ROWSET_BLOB_ISEQSTREAM	= 0x00000200,
	ROWSET_BLOB_ILOCKBYTES	= 0x00000400,
	ROWSET_BLOB_ISTORAGE	= 0x00000800,
	ROWSET_BLOB_ISTREAM		= 0x00001000,
};

enum COMMAND_OPTIONS
{
	COMMAND_ROWSAFFECTED	= 0x00000001,
	COMMAND_RELEASEROWSET	= 0x00000002,
	COMMAND_NOCOMMANDTEXT	= 0x00000010,
};

enum NOTIFY_OPTIONS
{
	NOTIFY_METHODCALLS			= 0x00000001,
	NOTIFY_OTHERCALLS			= 0x00000004,
	NOTIFY_ADDREF				= 0x00000008,
	NOTIFY_RELEASE				= 0x00000010,
	NOTIFY_QUERYINTEFACE		= 0x00000020,
	NOTIFY_TIMINGS				= 0x00000040,

	//Notifications
	NOTIFY_IDBASYNCHNOTIFY		= 0x00000100,
	NOTIFY_IROWSETNOTIFY		= 0x00000200,
	NOTIFY_IROWPOSITIONCHANGE	= 0x00000400,
};


typedef struct _SCHEMAINFO
{
	const GUID* pguidSchema;
	CHAR*		pszSchemaName;
	ULONG		cRestrictions;
	struct
	{
		ULONG   iOrdinal;
		CHAR*	pszName;
	} rgResInfo[MAX_RESTRICTIONS];

} SCHEMAINFO;


/////////////////////////////////////////////////////////////////////
// CDialogBase
//
/////////////////////////////////////////////////////////////////////
class CDialogBase
{
public:
	//constructors
	CDialogBase(HWND hWnd, HINSTANCE hInst);
	virtual ~CDialogBase();

	//members
	virtual ULONG Destroy();

	//Data
	HWND		m_hWnd;
	HINSTANCE	m_hInst;
};



/////////////////////////////////////////////////////////////////////
// CListBox
//
/////////////////////////////////////////////////////////////////////
class CListBox : public CDialogBase
{
public:
	//constructors
	CListBox(HWND hWnd, HINSTANCE hInst, CMainWindow* pCMainWindow);
	virtual ~CListBox();

	//abstract members
	virtual ULONG	Display(HWND hWndParent, UINT x, UINT y, UINT iWidth, UINT iHeight, DWORD dwFlags, void* lParam);
	virtual COptionsDlg* GetOptionsObj();

	//members
	virtual BOOL	InitControls(HWND hWnd);
	virtual BOOL	RefreshControls();
	virtual BOOL	CopyTo(HWND hWndTo);

	//ListBox (Notifcations)
	virtual HRESULT ClearNotifications();
	virtual LONG    OutputText(LONG iIndex, CHAR* pszFmt, ...);
	virtual LONG	OutputLineEnd();
	
	virtual ULONG	OutputAddRef(IUnknown* pIUnknown, CHAR* pszText = NULL);
	virtual ULONG	OutputRelease(IUnknown** ppIUnknown, CHAR* pszText = NULL, ULONG ulExpectedRefCount = 1);
	virtual HRESULT OutputQI(IUnknown* pIUnknown, REFIID riid, IUnknown** ppIUnknown, CHAR* pszFmt = NULL);

	virtual HRESULT OutputNotification(DWORD dwNotifyType, CHAR* pszFmt, ...);
	virtual HRESULT OutputPreMethod(CHAR* pszFmt, ...);
	virtual HRESULT OutputPostMethod(HRESULT hrActual, CHAR* pszFmt, ...);

	//Data
	CMainWindow*	m_pCMainWindow;

	//Timings
	LARGE_INTEGER	m_timerValue;
	LARGE_INTEGER	m_timerFreq;

	//Other
	LONG			m_iNotificationIndex;
};


/////////////////////////////////////////////////////////////////////
// CPropDlg
//
/////////////////////////////////////////////////////////////////////
class CPropDlg : public CDialogBase
{
public:
	//constructors
	CPropDlg(HWND hWnd, HINSTANCE hInst, CMainWindow* pCMainWindow, CListBox* pCListBox);
	virtual ~CPropDlg();

	//members
	virtual BOOL InitControls(HWND hWnd);
	virtual BOOL RefreshControls();

	//Properties
	HRESULT GetProperties(HWND hWnd, SOURCE eSource, IUnknown* pIUnkProperties, ULONG* pcPropSets = NULL, DBPROPSET** prgPropSets = NULL);
	HRESULT SetProperties(HWND hWnd, SOURCE eSource, IUnknown* pIUnkProperties, IUnknown* pIUnkPropInfo, ULONG* pcPropSets = NULL, DBPROPSET** prgPropSets = NULL);
	HRESULT GetPropertyInfo(HWND hWnd, SOURCE eSource, IUnknown* pIUnkPropInfo);
	
	static BOOL WINAPI GetPropertiesProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI SetPropertiesProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI GetPropertyInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Helpers
	HRESULT DisplayGetProperties(HWND hWnd, GUID guidPropertySet);
	HRESULT DisplaySetProperties(HWND hWnd, ULONG* pcPropInfoSets, DBPROPINFOSET** prgPropInfoSets, WCHAR** ppStringBuffer, GUID guidPropertySet);
	HRESULT DisplayGetPropertyInfo(HWND hWnd, GUID guidPropertySet);

	//Data
	SOURCE			m_eSource;
	IUnknown*		m_pIUnkProperties;
	IUnknown*		m_pIUnkPropInfo;

	ULONG*			m_pcPropSets;
	DBPROPSET**		m_prgPropSets;

	//Backpointers
	CMainWindow*	m_pCMainWindow;
	CListBox*		m_pCListBox;
};


/////////////////////////////////////////////////////////////////////
// CConnectDlg
//
/////////////////////////////////////////////////////////////////////
class CConnectDlg : public CDialogBase
{
public:
	//constructors
	CConnectDlg(HWND hWnd, HINSTANCE hInst, CMainWindow* pCMainWindow);
	virtual ~CConnectDlg();

	//abstract members
	static BOOL WINAPI ConnectDlgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	virtual ULONG Display(IParseDisplayName* pIParseDisplayName = NULL, ENUMINFO* pEnumInfo = NULL);
	virtual COptionsDlg* GetOptionsObj();

	//Sheets
	static BOOL WINAPI ProviderProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI PropertiesProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI SecurityProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI OptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI TraceProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Enumerators
	virtual HRESULT DisplayBrowseEnumInfo(HWND hWnd);
	static BOOL WINAPI BrowseEnumeratorProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//members
	virtual BOOL LoadDefaults();
	virtual BOOL ResetDefaults();
	virtual BOOL SaveDefaults();

	//Recent Config
	virtual BOOL LoadRecentConfig(ULONG iRecentConfig);
	virtual BOOL AddRecentConfig(CHAR* pszConfigName = NULL);
	virtual BOOL RemoveRecentConfig(CHAR* pszConfigName);
	CList<CHAR*>	m_listConfigs;
	
	//Recent Files
	virtual BOOL LoadRecentFile(ULONG iRecentFile);
	virtual BOOL AddRecentFile(CHAR* pszFileName);
	virtual BOOL RemoveRecentFile(CHAR* pszFileName);
	CList<CHAR*>	m_listFiles;
	
	//Provider
	virtual BOOL InitProvider(HWND hWnd);
	virtual BOOL RefreshProvider();
	virtual BOOL RefreshEnum(BOOL fReconnect = FALSE);
	virtual BOOL UpdateProvider();

	//Properties
	virtual BOOL InitProperties(HWND hWnd);
	virtual BOOL RefreshProperties();
	virtual BOOL UpdateProperties();

	//Security
	virtual BOOL InitSecurity(HWND hWnd);
	virtual BOOL RefreshSecurity();
	virtual BOOL UpdateSecurity();

	//Options
	virtual BOOL InitOptions(HWND hWnd);
	virtual BOOL RefreshOptions();
	virtual BOOL UpdateOptions();

	//Trace
	virtual BOOL InitTrace(HWND hWnd);
	virtual BOOL RefreshTrace();
	virtual BOOL UpdateTrace();

	//Connection
	virtual HRESULT InitPropCombo(HWND hWndCombo, ULONG cItems, NAMEMAP* rgNameMap, LONG lParam);
	virtual HRESULT GetAdvProperties();

	virtual HRESULT GetProviderName();
	virtual HRESULT CreateProviderInstance();
	virtual HRESULT	GetPropSets();
	virtual HRESULT FullConnect();

	//IDataInitialize
	static BOOL WINAPI GetDataSourceProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	virtual HRESULT GetInitString(IUnknown* pIUnknown, BOOL fIncludePassword, WCHAR** ppwszInitString = NULL);
	virtual HRESULT SaveInitString(WCHAR* pwszFileName, WCHAR* pwszInitString, DWORD dwCreateOpts = CREATE_ALWAYS);
	virtual HRESULT LoadInitString(WCHAR* pwszFileName, WCHAR** pwszInitString = NULL);
	
	virtual HRESULT ConnectFromFile(WCHAR* pwszInitString, IUnknown* pIUnkOuter = NULL, REFIID riid = IID_IUnknown);
	virtual HRESULT ConnectFromString(WCHAR* pwszInitString, IUnknown* pIUnkOuter = NULL, REFIID riid = IID_IUnknown, IUnknown* pExistingDataSource = NULL);

	//IDBPromptInitialize
	virtual	HRESULT PromptDataSource(DBPROMPTOPTIONS dwPromptOptions, REFIID riid = IID_IUnknown);
	virtual	HRESULT PromptFileName();
	
	virtual IDataInitialize*		const pIDataInitialize();
	virtual IDBPromptInitialize*	const pIDBPromptInitialize();

	//Data
	CMainWindow*    m_pCMainWindow;
	CEnum*			m_pCEnum;
	CPropDlg*		m_pCPropDlg;
	CListBox*		m_pCListBox;

	//Enum
	IParseDisplayName*	m_pIParseDisplayName;
	ENUMINFO			m_EnumInfo;
	IUnknown*			m_pIUnknown;

	//Properties
	HWND			m_hWndSource;
	DBPROPID		m_ePropSource;
	ULONG			m_cPropSets;
	DBPROPSET*		m_rgPropSets;

	//Saved Configuration
	CHAR			m_szConfigName[MAX_NAME_LEN+1];

	//Provider Page
	HWND			m_hWndProvider;
	WCHAR			m_wszLocation[MAX_NAME_LEN+1];		// DBPROP_INIT_LOCATION
	WCHAR			m_wszDataSource[MAX_NAME_LEN+1];	// DBPROP_INIT_DATASOURCE
	WCHAR			m_wszUserID[MAX_NAME_LEN+1];		// DBPROP_AUTH_USERID
	WCHAR			m_wszPassword[MAX_NAME_LEN+1];		// DBPROP_AUTH_PASSWORD
	LONG			m_dwPromptProp;
	LONG			m_dwhWndProp;

	//Properties Page
	HWND			m_hWndProperties;
	WCHAR			m_wszProvString[MAX_NAME_LEN+1];	// DBPROP_INIT_PROVIDERSTRING
	WCHAR			m_wszCatalog[MAX_NAME_LEN+1];		// DBPROP_INIT_CATALOG
	LCID			m_dwlcidProp;
	LONG			m_dwAsynchProp;
	LONG			m_dwTimeoutProp;
	LONG			m_dwModeProp;

	//Security Page
	HWND			m_hWndSecurity;
	LONG			m_dwProtectionProp;
	LONG			m_dwImpersonateProp;
	VARIANT_BOOL	m_dwMaskPasswordProp;
	VARIANT_BOOL	m_dwEncryptPasswordProp;
	VARIANT_BOOL	m_dwCacheProp;
	VARIANT_BOOL	m_dwPersistProp;
	VARIANT_BOOL	m_dwPersistEncryptProp;
	WCHAR			m_wszIntegrated[MAX_NAME_LEN+1];	// DBPROP_INIT_INTEGRATED

	//Options Page
	HWND			m_hWndOptions;
	DWORD			m_dwCLSCTX;
	WCHAR			m_wszRemoteServer[MAX_NAME_LEN+1];
	DWORD			m_dwConnectOpts;

	//Other Saved Config Info
	WCHAR			m_wszCmdBuffer[MAX_NAME_LEN+1];

	//Trace Page
	HWND			m_hWndTrace;

	//ServiceComponets
	WCHAR					m_wszInitString[MAX_QUERY_LEN];

private:
	IDataInitialize*		m_pIDataInitialize;
	IDBPromptInitialize*	m_pIDBPromptInitialize;
};


/////////////////////////////////////////////////////////////////////
// COptionsDlg
//
/////////////////////////////////////////////////////////////////////
class COptionsDlg : public CDialogBase
{
public:
	//constructors
	COptionsDlg(HWND hWnd, HINSTANCE hInst, CMainWindow* pCMainWindow);
	virtual ~COptionsDlg();

	//abstract members
	virtual ULONG Display();
	static BOOL WINAPI DataSourceOptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI RowsetOptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI CommandOptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI NotifyOptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI ErrorOptionsProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//DataSource
	virtual BOOL InitDataSourceOptions(HWND hWnd);
	virtual BOOL GetDataSourceOptions();
		
	//Rowset
	virtual BOOL InitRowsetOptions(HWND hWnd);
	virtual BOOL GetRowsetOptions();

	//Command
	virtual BOOL InitCommandOptions(HWND hWnd);
	virtual BOOL GetCommandOptions();

	//Notifications
	virtual BOOL InitNotifyOptions(HWND hWnd);
	virtual BOOL GetNotifyOptions();
		
	//Errors
	virtual BOOL InitErrorOptions(HWND hWnd);
	virtual BOOL GetErrorOptions();
		
	//Registry
	virtual HRESULT SaveOptions();
	virtual HRESULT RestoreOptions();

	//Data
	CMainWindow*    m_pCMainWindow;

	//DataSource
	HWND	m_hWndDataSourceOptions;
	DWORD   m_dwDSOCLSCTX;
	DWORD	m_dwDataSourceOpts;
	
	//Command
	HWND	m_hWndCommandOptions;
	GUID	m_guidDialect;		
	WCHAR	m_wszDialect[MAX_NAME_LEN+1];		
	DWORD	m_dwCommandOpts;
	
	//Rowset
	HWND	m_hWndRowsetOptions;
	DWORD	m_dwBindingType;
	DWORD	m_dwConvFlags;
	DWORD	m_dwRowsetOpts;

	//Notifications
	HWND	m_hWndNotifyOptions;
	DWORD	m_dwNotifyOpts;		

	//Errors
	HWND	m_hWndErrorOptions;
};


/////////////////////////////////////////////////////////////////////
// CSchemaDlg
//
/////////////////////////////////////////////////////////////////////
class CSchemaDlg : public CDialogBase
{
public:
	//constructors
	CSchemaDlg(HWND hWnd, HINSTANCE hInst, CMDIChild* pCMDIChild);
	virtual ~CSchemaDlg();

	//abstract members
	virtual ULONG Display();
	static BOOL WINAPI SchemaRowsetProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL WINAPI SchemaTreeProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	//Schema
	virtual HRESULT InitSchemas(HWND hWnd);
	virtual HRESULT GetSelectedSchema(SCHEMAINFO** ppSchemaInfo, ULONG* pdwRestrictions = NULL);
	virtual HRESULT GetSelectedRestrictions();
	virtual HRESULT ChangeRestrictions();
	virtual HRESULT InitSchemaCombo(BOOL fShowSupported);

	//TreeView
	virtual HRESULT		InitTreeView(HWND hWnd);
	virtual HRESULT		DisplayTree();
	virtual HRESULT		RefreshTreeControls();
	virtual CRowset*	const pCTreeRowset();

	//Data
	CMDIChild*  m_pCMDIChild;
	HWND		m_hWndSchemas;
	HWND		m_hWndTreeWnd;
	HWND		m_hWndTreeView;
	CRowset*    m_pCTreeRowset;

	//Saved Dialog Values
	BOOL		m_fEditing;
	BOOL		m_fActive;

	ULONG		m_cSchemas;
	GUID*		m_rgSchemas;
	ULONG*		m_rgRestrictionSupport;

	SCHEMAINFO	m_SchemaInfo;
	ULONG		m_iSchemaIndex;
	ULONG		m_iOldSchemaIndex;

	ULONG		m_cRestrictions;
	VARIANT		m_rgRestrictions[MAX_RESTRICTIONS];
	
	BOOL		m_fUseRestrictions;
	BOOL		m_fUseProperties;
	BOOL		m_fShowSupported;
};


#endif	//_CDIALOG_H_
